<?php
namespace VM\ApiBundle\DataFixtures\ORM;

use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use VM\ApiBundle\Entity\CreatorStages;
use VM\ApiBundle\Entity\CreatorStagesParts;
use VM\ApiBundle\Entity\CreatorStagesSteps;


class LoadCreatorStages extends AbstractFixture implements OrderedFixtureInterface
{
    private $CreatorStagesData = array(
        array(
            'symbol' => 'NOTARY',
            'name' => 'Notariusz',
            'steps' => array(
                array('name' => 'Nazwa spółki','index' => 1),
                array('name' => 'Siedziba spółki','index' => 2),
                array('name' => 'Zakres działania','index' => 3),
                array('name' => 'Struktura władz','index' => 4),
                array('name' => 'Reprezentacja','index' => 5),
                array('name' => 'Umowa spółki','index' => 6),
                array('name' => 'Podpisanie umowy','index' => 7),

            ),
            'parts' => array(
                array('start' => '0.0','end' => '25','percent_point' => '15.8','step_index' => 1,'index' => 1),
                array('start' => '25.3','end' => '37','percent_point' => '23.2','step_index' => 2,'index' => 2),
                array('start' => '37.3','end' => '60','percent_point' => '37.7','step_index' => 3,'index' => 3),
                array('start' => '60.3','end' => '111.0','percent_point' => '69.6','step_index' => 4,'index' => 4),
                array('start' => '111.3','end' => '133.5','percent_point' => '83.4','step_index' => 5,'index' => 5),
                array('start' => '133.8','end' => '140.0','percent_point' => '87.7','step_index' => 6,'index' => 6),
                array('start' => '140.3','end' => '146.0','percent_point' => '91.4','step_index' => 7,'index' => 7),
                array('start' => '146.3','end' => '160.0','percent_point' => '0','step_index' => NULL,'index' => 8),
            ),
        ),
        array(
            'symbol' => 'ESTATE',
            'name' => 'Nieruchomości',
            'steps' => array(
                array('name' => 'Rodzaj lokalu','index' => 1),
                array('name' => 'Wybór lokali','index' => 2),
                array('name' => 'Umowa najmu','index' => 3),
                array('name' => 'Podpisanie umowy','index' => 4)
            ),
            'parts' => array(
                array('start' => '0.0','end' => '18.5','percent_point' => '11.7','step_index' => 1,'index' => 1),
                array('start' => '18.8','end' => '36','percent_point' => '23.0','step_index' => 2,'index' => 2),
                array('start' => '36.3','end' => '53.0','percent_point' => '34.0','step_index' => 2,'index' => 3),
                array('start' => '53.3','end' => '69.0','percent_point' => '44.2','step_index' => 2,'index' => 4),
                array('start' => '69.3','end' => '88.0','percent_point' => '56.1','step_index' => 2,'index' => 5),
                array('start' => '88.3','end' => '105.5','percent_point' => '67.5','step_index' => 2,'index' => 6),
                array('start' => '105.8','end' => '127.0','percent_point' => '81.2','step_index' => 2,'index' => 7),
                array('start' => '127.3','end' => '142.0','percent_point' => '90.7','step_index' => 3,'index' => 8),
                array('start' => '142.3','end' => '149.0','percent_point' => '95.0','step_index' => 4,'index' => 9),
                array('start' => '149.3','end' => '156.0','percent_point' => '0','step_index' => NULL,'index' => 10)
            ),
        ),   
        array(
            'symbol' => 'BANK',
            'name' => 'Bank',
            'steps' => array(
                array('name' => 'Rodzaj usługi','index' => 1),
                array('name' => 'Wybór usługi','index' => 2),
                array('name' => 'Umowa bankowa','index' => 3),
                array('name' => 'Podpisanie umowy','index' => 4),
            ),
            'parts' => array(
                array('start' => '0.0','end' => '8.5','percent_point' => '5.40','step_index' => 1,'index' => 1),
                array('start' => '9.1','end' => '38.4','percent_point' => '23.70','step_index' => 2,'index' => 2),
                array('start' => '39.0','end' => '95.4','percent_point' => '58.70','step_index' => 2,'index' => 3),
                array('start' => '96.0','end' => '140.4','percent_point' => '86.40','step_index' => 2,'index' => 4),
                array('start' => '141.0','end' => '150.0','percent_point' => '92.20','step_index' => 3,'index' => 5),
                array('start' => '150.6','end' => '155.8','percent_point' => '95.50','step_index' => 4,'index' => 6),
                array('start' => '156.4','end' => '162','percent_point' => '0','step_index' => NULL,'index' => 7),
            ),
        ),
        array(
            'symbol' => 'OFFICE_KRS',
            'name' => 'Biuro KRS',
            'steps' => array(
                array('name' => 'KRS-W3','index' => 1),
                array('name' => 'KRS-WE, KRS-WM, KRS-WK','index' => 2),
                array('name' => 'KRS-WA, KRS-WL','index' => 3),
                array('name' => 'Wybór dokumentów','index' => 4),

            ),
            'parts' => array(
                array('start' => '0.0','end' => '21.0','percent_point' => '15.5','step_index' => 1,'index' => 1),
                array('start' => '21.3','end' => '39','percent_point' => '28.1','step_index' => 2,'index' => 2),
                array('start' => '39.3','end' => '51.8','percent_point' => '38.0','step_index' => 3,'index' => 3),
                array('start' => '52.1','end' => '122.0','percent_point' => '88.7','step_index' => 4,'index' => 4),
                array('start' => '122.3','end' => '130.0','percent_point' => '94.0','step_index' => 5,'index' => 5),
                array('start' => '130.5','end' => '138.0','percent_point' => '0','step_index' => NULL,'index' => 6),
            ),
        ),
    );

    /**
     * @var \Doctrine\ORM\EntityManager
     */
    private $EntityManager;

    public function load(ObjectManager $EntityManager)
    {
        $this->EntityManager = $EntityManager;

        foreach($this->CreatorStagesData as $creatorStageData)
        {
            $CreatorStage = new CreatorStages();

            $CreatorStage->setName($creatorStageData['name']);
            $CreatorStage->setSymbol($creatorStageData['symbol']);

            $EntityManager->persist($CreatorStage);

            foreach($creatorStageData['steps'] as $stepData)
            {
                $Step = $this->createStep($stepData);
                $Step->setStage($CreatorStage);
                $EntityManager->persist($Step);
            }

            foreach($creatorStageData['parts'] as $partData)
            {
                $Part = $this->createPart($partData);
                $Part->setStage($CreatorStage);
                $EntityManager->persist($Part);
            }
        }

        $EntityManager->flush();
    }

    /**
     * @param $data
     * @return CreatorStagesSteps
     */
    private function createStep($data)
    {
        $Step = new CreatorStagesSteps();

        $Step->setName($data['name']);
        $Step->setIndex($data['index']);

        return $Step;
    }

    /**
     * @param $data
     * @return CreatorStagesParts
     */
    private function createPart($data)
    {
        $Part = new CreatorStagesParts();

        $Part->setStart($data['start']);
        $Part->setEnd($data['end']);
        if(!is_null($data['percent_point']))
        {
            $Part->setPercentPoint($data['percent_point']);
        }
        if(!is_null($data['step_index']))
        {
            $Part->setStepIndex($data['step_index']);
        }
        $Part->setIndex($data['index']);

        return $Part;
    }

    public function getOrder()
    {
        return 10;
    }
}